/*
 * Decompiled with CFR 0.152.
 */
package ags.ui;

import ags.communication.DataUtil;
import ags.communication.GenericHost;
import ags.communication.TransferHost;
import ags.ui.IVirtualScreen;
import ags.ui.Util;
import java.awt.Image;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextScreen40
implements IVirtualScreen {
    byte[] buffer = new byte[8192];
    byte[] lastScreen = new byte[this.buffer.length];
    String spaces = Util.repeat(' ', 40);
    private boolean alreadyActive = false;
    boolean stale = true;

    public void insert(int start, byte ... b) {
        for (int i = 0; i < b.length; ++i) {
            this.buffer[i + start] = b[i];
        }
    }

    public void insert(int start, int ... b) {
        for (int i = 0; i < b.length; ++i) {
            this.buffer[i + start] = (byte)(b[i] & 0xFF);
        }
    }

    public TextScreen40() {
        this.clear();
        this.insert(250, 176, 255);
        this.insert(376, 23, 255, 255);
        this.insert(504, 40, 0, 0, 23);
        this.insert(632, 0, 0, 0, 247, 0, 255, 255, 255);
        this.insert(760, 0, 0, 0, 0, 255, 255, 255, 255);
        this.insert(888, 0, 0, 0, 160, 0, 3, 255, 255);
        this.insert(1016, 160, 0, 0, 255, 0, 3, 255, 255);
    }

    public void clear() {
        for (int i = 0; i < 24; ++i) {
            this.drawText(0, i, this.spaces, false);
        }
    }

    private int getYOffset(int i) {
        return 128 * (i % 8) + 40 * (i / 8);
    }

    public void drawText(int x, int y, String text, boolean invert) {
        block6: {
            block5: {
                if (y < 0 || y > 23) {
                    return;
                }
                int offset = this.getYOffset(y);
                if (invert) break block5;
                GenericHost.getInstance();
                if (!GenericHost.isLegacyMode()) break block6;
            }
            text = text.toUpperCase();
        }
        for (int i = 0; i < text.length(); ++i) {
            if (i + x < 0 || i + x > 39) continue;
            byte c = (byte)text.charAt(i);
            this.buffer[offset + i + x] = invert ? (byte)(c & 0x3F) : (byte)(c | 0x80);
        }
    }

    public void drawBox(int x1, int y1, int x2, int y2, boolean invert) {
        String spaces = Util.repeat(' ', x2 - x1 + 1);
        for (int i = y1; i <= y2; ++i) {
            this.drawText(x1, i, spaces, invert);
        }
    }

    public void drawBorder(int x1, int y1, int x2, int y2, boolean invert) {
        int xSize = x2 - x1 + 1;
        String line = Util.repeat('-', xSize);
        this.drawText(x1 - 1, y1 - 1, "/" + line + "\\", invert);
        for (int i = y1; i <= y2; ++i) {
            String bar = "|";
            if (invert) {
                bar = "!";
            }
            this.drawText(x1 - 1, i, bar, invert);
            this.drawText(x2 + 1, i, bar, invert);
        }
        this.drawText(x1 - 1, y2 + 1, "\\" + line + "/", invert);
    }

    public void drawCursor(int x, int y) {
        this.drawText(x, y, ">", true);
    }

    public void drawImage(int x, int y, int x1, int y1, Image i) {
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getDisplayOffset() {
        return 1024;
    }

    public int[] getActivateCode() {
        return new int[]{173, 81, 192, 173, 84, 192, 141, 12, 192, 141, 14, 192, 96};
    }

    public void activate(TransferHost host) {
        try {
            if (this.alreadyActive) {
                return;
            }
            this.alreadyActive = true;
            host.toggleSwitch(49233);
            host.toggleSwitch(49236);
            host.toggleSwitch(49166);
        }
        catch (IOException ex) {
            Logger.getLogger(TextScreen40.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void send(TransferHost host) {
        try {
            if (this.stale) {
                host.sendRawData(this.buffer, this.getDisplayOffset(), 0, this.buffer.length);
            } else {
                byte[] send = DataUtil.packScreenUpdate(this.getDisplayOffset(), this.lastScreen, this.buffer);
                host.sendCompressedData(send);
            }
            this.stale = false;
            this.copyScreen();
        }
        catch (IOException ex) {
            Logger.getLogger(TextScreen40.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.activate(host);
    }

    protected void copyScreen() {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.lastScreen[i] = this.buffer[i];
        }
    }
}

